#!/bin/bash

set -e

# Скрипт для генерации моделей клиента к справочнику из сваггера

ARCADIA_ROOT="${PWD}"
SVN_ARCADIA_ROOT="svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia"

while [[ ! -e "${ARCADIA_ROOT}/.arcadia.root" ]]; do
    if [[ "${ARCADIA_ROOT}" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "${ARCADIA_ROOT}")"
done

TMP=`mktemp -d`
generated="src/generated/java"
project_dir="$ARCADIA_ROOT/direct/libs/organizations-swagger-models"
outdir="$TMP/out"

#swagger_codegen="contrib/java/io/swagger/swagger-codegen-cli/2.4.5"
# У сваггера есть проблемы, подробнее в https://st.yandex-team.ru/DIRECT-99303 и https://h.yandex-team.ru/?https%3A%2F%2Fgithub.com%2Fswagger-api%2Fswagger-codegen%2Fissues%2F9547
# В sb лежит наколеночный фикс
swagger_codegen_url="https://proxy.sandbox.yandex-team.ru/1022574645"
swagger_codegen_out="swagger_codegen"

swagger_schemas=(
    "sprav/tycoon/public-api/src/main/resources/api.yaml"
    "sprav/tycoon/common/model/src/main/resources/swagger.yaml"
    "sprav/tycoon/common/model/src/main/resources/storage.json"
    "sprav/java/libs/editor-model/src/main/resources/sprav-editor.json"
    "sprav/java/signals-common/src/main/resources/altay-signals.json"
)
schemas_dir="schemas"
schemas_jar="schemas.jar"

generated_dir="generated"

echo "checking out swagger-codegen..."
# У сваггера есть проблемы, подробнее в https://st.yandex-team.ru/DIRECT-99303 и https://h.yandex-team.ru/?https%3A%2F%2Fgithub.com%2Fswagger-api%2Fswagger-codegen%2Fissues%2F9547
# В sb лежит наколеночный фикс
#$ARCADIA_ROOT/ya make -q -o "$outdir/$swagger_codegen_out" "$ARCADIA_ROOT/$swagger_codegen"
mkdir -p "$outdir/$swagger_codegen_out"
mkdir -p "$outdir/$schemas_dir"
wget -q "$swagger_codegen_url" -O "$outdir/$swagger_codegen_out/swagger-codegen-cli.jar"
swagger_codegen_jar=$(find "$outdir/$swagger_codegen_out" -name '*.jar')

echo "exporting schema files..."
for s in ${swagger_schemas[@]}; do
    svn export --force "$SVN_ARCADIA_ROOT/$s" "$outdir/$schemas_dir/"
done

echo "fixing schemas..."
sed -i .bak 's/\/storage/storage/g' $outdir/$schemas_dir/*
rm $outdir/$schemas_dir/*.bak
sed -i .bak 's/\/sprav-editor/sprav-editor/g' $outdir/$schemas_dir/*
rm $outdir/$schemas_dir/*.bak

echo "creating jar with schemas..."
$ARCADIA_ROOT/ya tool jar cf "$outdir/$schemas_jar" -C "$outdir/$schemas_dir" .

echo "generating models..."
$ARCADIA_ROOT/ya tool java17 -cp "$swagger_codegen_jar:$outdir/$schemas_jar" -Dmodels -DenumPropertyNaming=UPPERCASE \
    io.swagger.codegen.SwaggerCodegen generate \
    -i "$outdir/$schemas_dir/api.yaml" \
    -l java \
    -o "$outdir/$generated_dir" \
    --library jersey2 \
    --additional-properties java8=true,dateLibrary=java8,supportJava6=false,hideGenerationTimestamp=true \
    --api-package ru.yandex.direct.organizations.swagger.client \
    --model-package ru.yandex.direct.organizations.swagger.model \
    --type-mappings integer=Long # Затыкание проблемы https://github.com/swagger-api/swagger-codegen/issues/8874

rm -rf "$project_dir/$generated"
mkdir -p "$project_dir/$generated"
mv $outdir/$generated_dir/src/main/java/* "$project_dir/$generated"
rm -rf "$outdir"

echo "**************************************"
echo -e "Generation finished.\nPlease run import optimization and code refactoring,\nand try to build the project for potential compatibility issues"
echo "**************************************"
