package ru.yandex.direct.pokazometer;

import java.util.List;

import javax.annotation.Nullable;

/**
 * Группа фраз и соотвествующих им регионов
 */
public class GroupRequest {
    private List<PhraseRequest> phrases;
    private List<Long> geo;

    /**
     * Создает группу фраз с регионами
     *
     * @param phrases список фраз
     * @param geo     список соответствующих фразам регионов
     */
    public GroupRequest(List<PhraseRequest> phrases, List<Long> geo) {
        this.phrases = phrases;
        this.geo = geo;
    }

    /**
     * @return список фраз
     */
    public List<PhraseRequest> getPhrases() {
        return phrases;
    }

    /**
     * @return список соответствующих фразам регионов
     */
    @Nullable
    public List<Long> getGeo() {
        return geo;
    }

    @Override
    public String toString() {
        return "GroupRequest{" +
                "phrases=" + phrases +
                ", geo=" + geo +
                '}';
    }
}
