package ru.yandex.direct.pokazometer;

import java.util.List;

public class GroupResponse {
    private final List<PhraseResponse> phrases;
    private final List<Throwable> errors;

    /**
     * Создает группу фраз с регионами
     *
     * @param phrases список фраз
     */
    private GroupResponse(List<PhraseResponse> phrases, List<Throwable> errors) {
        this.errors = errors;
        this.phrases = phrases;
    }

    @SuppressWarnings("WeakerAccess")
    public static GroupResponse success(List<PhraseResponse> phrases) {
        return new GroupResponse(phrases, null);
    }

    @SuppressWarnings("WeakerAccess")
    public static GroupResponse failure(List<Throwable> errors) {
        return new GroupResponse(null, errors);
    }

    /**
     * @return список фраз
     */
    public List<PhraseResponse> getPhrases() {
        return phrases;
    }

    public List<Throwable> getErrors() {
        return errors;
    }

    public boolean hasErrors() {
        return errors != null;
    }

    @Override
    public String toString() {
        return "GroupResponse{" +
                "phrases=" + phrases +
                ", errors=" + errors +
                '}';
    }
}
