package ru.yandex.direct.pokazometer.internal;

import java.util.Collection;

/**
 * JSON RPC 2.0 Params for Pokazometer ClicksDistribution service
 */
public class ClicksDistributionParams {
    private Collection<String> phrases;
    private Collection<Long> regions;

    public ClicksDistributionParams(Collection<String> phrases, Collection<Long> regions) {
        this.phrases = phrases;
        this.regions = regions;
    }

    /**
     * @return for which phrases Pokazometer should return data
     */
    public Collection<String> getPhrases() {
        return phrases;
    }

    /**
     * @return for which geo regions Pokazometer should return data
     */
    public Collection<Long> getRegions() {
        return regions;
    }
}
