package ru.yandex.direct.pokazometer.internal;

import java.util.List;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * объект результата JSON RPC 2.0 вызова сервиса ClicksDistribution в показометре
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ClicksDistributionResult {
    private List<List<CostData>> distribution;
    private int refDays;
    private List<Throwable> errors;

    /**
     * @return распределение стоимостей по фразам и количествам кликов
     */
    public List<List<CostData>> getDistribution() {
        return distribution;
    }

    /**
     * @param value распределение стоимостей по фразам и количествам кликов
     */
    public void setDistribution(List<List<CostData>> value) {
        distribution = value;
    }

    /**
     * @param value количество дней, за которые посчитан результат, обычно 7
     */
    public void setRefDays(int value) {
        refDays = value;
    }

    public List<Throwable> getErrors() {
        return errors;
    }

    public boolean isSuccessful() {
        return errors == null;
    }

    public static ClicksDistributionResult failure(List<Throwable> errors) {
        ClicksDistributionResult result = new ClicksDistributionResult();
        result.errors = errors;
        return result;
    }
}
