package ru.yandex.direct.process;

import java.time.Duration;
import java.util.Objects;

public class DockerNetwork implements AutoCloseable {
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30);

    private final Docker docker;
    private final String name;
    private final String id;

    public DockerNetwork(Docker docker, String name) throws InterruptedException {
        this.docker = docker;
        this.name = name;
        this.id = docker.checkOutput("network", "create", name).trim();
    }

    public String getName() {
        return name;
    }

    String getId() {
        return id;
    }

    @Override
    public void close() {
        // Старые версии docker не выводят в stdout удалённый id, новые выводят.
        String removedId = docker.checkOutputUninterruptibly(CLOSE_TIMEOUT, "network", "rm", id).trim();
        if (!removedId.isEmpty() && !Objects.equals(removedId, id)) {
            throw new IllegalStateException(
                    "`docker network rm` returned unexpected network id: " + removedId
                            + ", expected: " + id
            );
        }
    }
}
