#!/bin/sh
set -e
set -u

if grep -q Alpine /etc/issue; then
    GROUP_RE="^.*:x:${HOST_GID}:.*$"
    GROUP_STR="${HOST_USERNAME}:x:${HOST_GID}:"
    PASSWD_RE="^.*:x:${HOST_UID}:.*$"
    PASSWD_STR="${HOST_USERNAME}:x:${HOST_UID}:${HOST_GID}:Host user,,,:/var/empty:/bin/sh"

    grep -q "$GROUP_RE" /etc/group \
        && sed -i -e "s|$GROUP_RE|$GROUP_STR|" /etc/group \
            || echo "$GROUP_STR" >> /etc/group

    grep -q "$PASSWD_RE" /etc/passwd \
        && sed -i -e "s|$PASSWD_RE|$PASSWD_STR|" /etc/passwd \
            || echo "$PASSWD_STR" >> /etc/passwd
elif grep -q Ubuntu /etc/issue; then
    groupadd --force --gid "${HOST_GID}" --non-unique "${HOST_USERNAME}"
    useradd --gid "${HOST_GID}" --uid "${HOST_UID}" --non-unique --no-create-home "${HOST_USERNAME}"
else
    echo "Unsupported container operating system:" 1>&2
    cat /etc/issue 1>&2
    exit 1
fi

exec_su() {
    EXECUTABLE="$1"
    shift
    ARGS_FILE="$(mktemp args.XXXXXX)"
    chmod +r "$ARGS_FILE"
    for arg in "$@"; do
        printf "%s\0" "$arg"
    done | head -c-1 | base64 > "$ARGS_FILE"
    EXECUTABLE="${EXECUTABLE}" ARGS_FILE="$ARGS_FILE" exec su "${HOST_USERNAME}" -p -c \
        'cat $ARGS_FILE 1>&2; cat "$ARGS_FILE" | base64 -d | xargs -0 "${EXECUTABLE}"'
}

exec_su ${ORIGINAL_ENTRYPOINT:-} "$@"
