# -*- coding: utf-8 -*-

import time
import logging

import click

from alive_checker import AliveChecker


@click.command(help="Background daemon process, for materializing /alive page")
@click.option('--url', '-u', type=str,
              help="alive url of service")
@click.option('--timeout', '-t', type=float, default=5.0,
              help="timeout for http request")
@click.option('--file', '-f', type=str, required=True,
              help="file, for result saving")
@click.option('--max-age', '-m', type=float, default=20.0,
              help="max age of alive file")
@click.option('--log-level', type=str, default="WARN",
              help="log level")
@click.option('--log-file', type=str,
              help="log file")
@click.option('--once/--no-once', default=False,
              help="do only one iteration, or run as daemon")
@click.option('--monrun/--no-monrun', default=False,
              help="don'e run iterations, just show current status of alive file")
def cli(url, timeout, file, max_age, log_level, log_file, once, monrun):
    configure_logging(log_file, log_level)

    checker = AliveChecker(url, timeout, file, max_age)

    if monrun:
        checker.monrun()
    elif once:
        checker.check()
    else:
        while True:
            checker.check()
            time.sleep(1)


def configure_logging(log_file, log_level):
    numeric_level = getattr(logging, log_level.upper(), None)
    if not isinstance(numeric_level, int):
        raise ValueError('Invalid log level: %s' % log_level)
    logging.basicConfig(
        level=numeric_level,
        filename=log_file,
        format='%(asctime)-15s %(levelname)s %(message)s',
    )


if __name__ == '__main__':
    cli()
