# -*- coding: utf-8 -*-

import time
import logging

import requests
from requests.exceptions import RequestException
from path import Path


class AliveChecker(object):
    def __init__(self, url, timeout, file, max_age):
        self.url = url
        self.timeout = timeout
        self.file = Path(file)
        self.max_age = max_age

    def check(self):
        if self.url is None:
            raise Exception("url is not specified")

        if self.file.isfile() and self._is_file_outdated():
            self._remove_file()

        resp = None
        try:
            resp = requests.get(self.url, timeout=self.timeout)
        except RequestException as e:
            logging.error("Url fetch error: {} - {}".format(self.url, e))

        if resp and resp.ok:
            self._renew_file(resp.content)
        else:
            logging.error("Fetch error: {} - {}".format(self.url, resp))
            self._remove_file()

    def monrun(self):
        if not self.file.isfile():
            print "2;alive file is absent"
        elif self._is_file_outdated():
            print "2;alive file is too old"
        else:
            if self.file.text().strip() == 'ok':
                print "0;OK"
            else:
                print "2;alive file content is not ok"

    def _is_file_outdated(self):
        return self.file.mtime + self.max_age < time.time()

    def _remove_file(self):
        self._last_content = None
        if self.file.isfile():
            self.file.remove()
            logging.info("File removed")

    def _renew_file(self, new_content):
        if self.file.isfile() and self.file.text() == new_content:
            self.file.touch()
            logging.info("File touched")
        else:
            tmp = self.file + ".tmp"
            tmp.write_text(new_content)
            tmp.rename(self.file)
            logging.info("File updated")
