import click

import thread_dumps
import thread_dumps_old
import traces
import messages
import format_json


class AliasedGroup(click.Group):
    def get_command(self, ctx, cmd_name):
        rv = click.Group.get_command(self, ctx, cmd_name)
        if rv is not None:
            return rv
        matches = [x for x in self.list_commands(ctx)
                   if x.startswith(cmd_name)]
        if not matches:
            return None
        elif len(matches) == 1:
            return click.Group.get_command(self, ctx, matches[0])
        ctx.fail('Too many matches: %s' % ', '.join(sorted(matches)))


if __name__ == '__main__':
    cli = AliasedGroup(context_settings=dict(help_option_names=['-h', '--help']))
    for cmd in (
            thread_dumps.cli,
            thread_dumps_old.cli,
            traces.cli,
            messages.cli,
            format_json.cli,
            ):
        cli.add_command(cmd)
    cli()
