# -*- coding: utf-8 -*-

import ast

from direct.direct_log.lib.simple_eval import SimpleEval


class Data(object):
    def __init__(self, x=0, y=0, z=0):
        self.x = x
        self.y = y
        self.z = z


class Test():
    def _eval(self, expr_string, data):
        expr = ast.parse(expr_string, mode="eval")
        return SimpleEval(expr, data).eval()

    def test_const_add(self):
        assert self._eval("1+1", Data()) == 2

    def test_var_sub(self):
        assert self._eval("x - 1", Data(6)) == 5

    def test_nexted_attr(self):
        assert self._eval("x.y - 1", Data(Data(0, 6))) == 5

    def test_startswith(self):
        assert self._eval("x.startswith('x')", Data('xxx')) is True
        assert self._eval("x.startswith('y')", Data('xxx')) is False
