# -*- coding: utf-8 -*-

import click

from yalibrary.upload import mds_uploader


@click.command(help="Upload data to MDS")
@click.option('--ttl', type=str,
              help="Time to live in days or inf")
@click.argument('filename', type=str)
def cli(ttl, filename):
    if ttl is None:
        ttl = 14
    elif ttl == 'inf':
        ttl = None
    else:
        ttl = int(ttl)
    ret = mds_uploader.do(
        [filename],
        ttl=int(ttl) if ttl is not None and ttl != 'inf' else None
    )
    url = mds_uploader.make_mds_url(ret)
    print "Url: " + url
    print "Ttl: " + ('inf' if ttl is None else str(ttl) + 'd')


if __name__ == '__main__':
    cli()
