import argparse
import logging
import sys
from logbroker.unified_agent.client.python import UnifiedAgentYdHandler


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--uri', default=None)
    parser.add_argument('--logger_name', default=None)

    args = parser.parse_args()

    log_formatter = logging.Formatter('%(message)s')
    log_handler = UnifiedAgentYdHandler(args.logger_name, args.uri)
    log_handler.setFormatter(log_formatter)
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)
    logger.addHandler(log_handler)

    while True:
        line = sys.stdin.readline().rstrip()
        line = line.rstrip()
        if len(line) == 0:
            break
        logger.info(line)


if __name__ == '__main__':
    main()
