#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yatest.common


def prepare_tables(ytw, source, dst_path, dst_table):
    """
    Заливает файл в формате YSON Text по указанному пути

    :param ytw: YT wrapper
    :param source: Файл с данными в YSON Text
    :param dst_path: Путь к директории
    :param dst_table: Имя таблицы
    """
    ytw.mkdir(dst_path, recursive=True)
    with open(yatest.common.source_path(source)) as f:
        data = [x if x.strip()[-1] == ';' else x + ';'  # При выгрузке из YQL вручную не проставляется ; в конце строки
                for x in f.readlines()]
        ytw.write_table(
            '/'.join([dst_path, dst_table]),
            '\n'.join(data).encode('utf-8'),
            raw=True,
            format="yson"
        )


def read_tables(ytw, dst_table):
    """
    Читает таблицу и складывает ее строки в список

    :param ytw: YT wrapper
    :param dst_table: Путь к таблице
    :return:
    """
    return [row for row in ytw.read_table(dst_table)]
