#include "ru_yandex_direct_queryrec_QueryrecJni.h"

#include <dict/recognize/queryrec/queryrecognizer.h>
#include <advq/java/libs/jniutil/util.h>
#include <util/stream/str.h>

TQueryRecognizer* recognizer(jlong handle) {
    return reinterpret_cast<TQueryRecognizer*>(handle);
}

JNIEXPORT jlong JNICALL Java_ru_yandex_direct_queryrec_QueryrecJni_create
  (JNIEnv* env, jclass, jbyteArray dictData, jbyteArray weightsData, jbyteArray regexpData)
{
    return JniWrapExceptions(env, [&]{
        TBlob dictBlob = TBlob::FromStringSingleThreaded(JniByteArrayToTString(env, dictData));
        TSimpleSharedPtr<NQueryRecognizer::TFactorMill> factorMill = new NQueryRecognizer::TFactorMill(dictBlob);

        TStringStream weightsInput(JniByteArrayToTString(env, weightsData));
        TStringStream regexpInput(JniByteArrayToTString(env, regexpData));
        return reinterpret_cast<jlong>(new TQueryRecognizer(factorMill, weightsInput, NULL, regexpInput));
    });
}

JNIEXPORT void JNICALL Java_ru_yandex_direct_queryrec_QueryrecJni_destroy
  (JNIEnv* env, jclass, jlong handle)
{
    return JniWrapExceptions(env, [&]{
        delete recognizer(handle);
    });
}

JNIEXPORT jdoubleArray JNICALL Java_ru_yandex_direct_queryrec_QueryrecJni_recognize
  (JNIEnv* env, jclass, jstring jText, jlong handle)
{
    return JniWrapExceptions(env, [&]{
        TJniStringData text(env, jText);
        auto query = UTF8ToWide(text.Data());
        auto answer = recognizer(handle)->RecognizeParsedQueryLanguage(query, nullptr);

        size_t length = answer.size() * 2;
        jdouble array[length];
        int arrayIndex = 0;
        for (const auto& langWeight : answer) {
            double weight = langWeight.second;
            if (!weight) {
                continue;
            }
            int lang = langWeight.first;
            array[arrayIndex++] = lang;
            array[arrayIndex++] = weight;
        }

        jdoubleArray result = env->NewDoubleArray(length);
        if (result == NULL) {
            throw TJniException(env);
        }

        env->SetDoubleArrayRegion(result, 0, length, array);

        return result;
    });
}
