package ru.yandex.direct.queryrec;

import java.util.Set;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import one.util.streamex.StreamEx;

import static ru.yandex.direct.utils.TextConstants.BEL_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.ENG_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.GER_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.KAZ_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.RUS_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.TUR_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UKR_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UZB_CYRILLIC_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UZB_LATIN_ALPHABET;

/**
 * Хранилище полезных констант
 */
public class QueryrecHelper {

    private static final String ALL_CYRILLIC_LETTERS =
            characterStream(RUS_ALPHABET + UKR_ALPHABET + BEL_ALPHABET + KAZ_ALPHABET + UZB_CYRILLIC_ALPHABET)
                    .distinct().joining();
    private static final String ALL_CYRILLIC_LETTERS_EXCEPT_RUSSIAN = characterStream(ALL_CYRILLIC_LETTERS)
            .filter(letter -> !RUS_ALPHABET.contains(letter.toString()))
            .joining();
    private static final String ALL_LATIN_LETTERS =
            characterStream(ENG_ALPHABET + GER_ALPHABET + TUR_ALPHABET + UZB_LATIN_ALPHABET)
                    .distinct().joining();

    // Буквы, которые могут содержаться и в кириллице, и в латинице.
    // Апострофы узбекского языка считаем буквами, т.к. по смыслу это именно буквы.
    private static final String SPECIAL_LETTERS =
            StreamEx.of(Sets.intersection(characterSet(ALL_CYRILLIC_LETTERS), characterSet(ALL_LATIN_LETTERS))
                    .stream())
                    .joining();

    /* CharMatcher'ы для алфавитов */
    static final CharMatcher ALL_CYRILLIC_LETTERS_MATCHER = CharMatcher.anyOf(ALL_CYRILLIC_LETTERS)
            .and(CharMatcher.noneOf(SPECIAL_LETTERS));
    static final CharMatcher ALL_LATIN_LETTERS_MATCHER = CharMatcher.anyOf(ALL_LATIN_LETTERS)
            .and(CharMatcher.noneOf(SPECIAL_LETTERS));
    static final CharMatcher ALL_CYRILLIC_LETTERS_EXCEPT_RUSSIAN_MATCHER =
            CharMatcher.anyOf(ALL_CYRILLIC_LETTERS_EXCEPT_RUSSIAN);

    public static final Set<Character> RUS_LETTERS = characterStream(RUS_ALPHABET).toImmutableSet();
    public static final Set<Character> ENG_LETTERS = characterStream(ENG_ALPHABET).toImmutableSet();

    private QueryrecHelper() {
    }

    public static StreamEx<Character> characterStream(String s) {
        return StreamEx.of(s.chars().mapToObj(i -> (char) i));
    }

    public static Set<Character> characterSet(String s) {
        return characterStream(s).toSet();
    }
}
