package ru.yandex.direct.queryrec;

import ru.yandex.direct.common.db.PpcProperty;

import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Пороги для определения узбекского языка. Queryrec плохо определяет узбекский, чаще всего
 * возвращает русский, английский или турецкий язык с низкой вероятностью.
 */
public class UzbekLanguageThresholds {

    /**
     * Дефолтные пороги для определения узбекского языка.
     */
    private static final double DEFAULT_CYRILLIC_UZBEK_TO_RUSSIAN_THRESHOLD = 0.6;
    private static final double DEFAULT_LATIN_UZBEK_TO_RUSSIAN_THRESHOLD = 0.8;
    private static final double DEFAULT_LATIN_UZBEK_TO_TURKISH_THRESHOLD = 0.9;
    private static final double DEFAULT_UNKNOWN_LANGUAGE_THRESHOLD = 0.8;

    /**
     * Проперти с порогами.
     */
    private final PpcProperty<Double> cyrillicUzbekToRussianThresholdProperty;
    private final PpcProperty<Double> latinUzbekToRussianThresholdProperty;
    private final PpcProperty<Double> uzbekToTurkishThresholdProperty;
    private final PpcProperty<Double> uzbekToUnknownThresholdProperty;

    public UzbekLanguageThresholds(PpcProperty<Double> cyrillicUzbekToRussianThresholdProperty,
                                   PpcProperty<Double> latinUzbekToRussianThresholdProperty,
                                   PpcProperty<Double> uzbekToTurkishThresholdProperty,
                                   PpcProperty<Double> uzbekToUnknownThresholdProperty) {
        this.cyrillicUzbekToRussianThresholdProperty = cyrillicUzbekToRussianThresholdProperty;
        this.latinUzbekToRussianThresholdProperty = latinUzbekToRussianThresholdProperty;
        this.uzbekToTurkishThresholdProperty = uzbekToTurkishThresholdProperty;
        this.uzbekToUnknownThresholdProperty = uzbekToUnknownThresholdProperty;
    }

    // В методах используется nvl() вместо getOrDefault(), чтобы не пришлось его мокать во всех тестах.

    double getCyrillicUzbekToRussianThreshold() {
        return nvl(cyrillicUzbekToRussianThresholdProperty.get(), DEFAULT_CYRILLIC_UZBEK_TO_RUSSIAN_THRESHOLD);
    }

    double getLatinUzbekToRussianThreshold() {
        return nvl(latinUzbekToRussianThresholdProperty.get(), DEFAULT_LATIN_UZBEK_TO_RUSSIAN_THRESHOLD);
    }

    double getUzbekToTurkishThreshold() {
        return nvl(uzbekToTurkishThresholdProperty.get(), DEFAULT_LATIN_UZBEK_TO_TURKISH_THRESHOLD);
    }

    double getUzbekToUnknownThreshold() {
        return nvl(uzbekToUnknownThresholdProperty.get(), DEFAULT_UNKNOWN_LANGUAGE_THRESHOLD);
    }
}
