package ru.yandex.direct.queryrec.model;

import java.util.Set;

import static ru.yandex.direct.queryrec.QueryrecHelper.ENG_LETTERS;
import static ru.yandex.direct.queryrec.QueryrecHelper.RUS_LETTERS;
import static ru.yandex.direct.queryrec.model.Alphabet.Type.CYRILLIC;
import static ru.yandex.direct.queryrec.model.Alphabet.Type.LATIN;
import static ru.yandex.direct.utils.TextConstants.BEL_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.CZE_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.ENG_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.EST_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.GER_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.KAZ_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.LAV_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.LIT_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.POL_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.POR_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.RUS_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.SPA_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.TUR_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UKR_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UZB_CYRILLIC_ALPHABET;
import static ru.yandex.direct.utils.TextConstants.UZB_LATIN_ALPHABET;

/**
 * Enum для хранения используемых в Директе алфавитов (с учетом их типов).
 */
public enum Alphabet {

    // Cyrillic
    RUSSIAN(CYRILLIC, RUS_ALPHABET),
    UKRAINIAN(CYRILLIC, UKR_ALPHABET),
    BELARUSIAN(CYRILLIC, BEL_ALPHABET),
    KAZAKH(CYRILLIC, KAZ_ALPHABET),
    UZBEK_CYRILLIC(CYRILLIC, UZB_CYRILLIC_ALPHABET),

    // Latin
    ENGLISH(LATIN, ENG_ALPHABET),
    GERMAN(LATIN, GER_ALPHABET),
    ESTONIAN(LATIN, EST_ALPHABET),
    LATVIAN(LATIN, LAV_ALPHABET),
    LITHUANIAN(LATIN, LIT_ALPHABET),
    TURKISH(LATIN, TUR_ALPHABET),
    UZBEK_LATIN(LATIN, UZB_LATIN_ALPHABET),
    SPANISH(LATIN, SPA_ALPHABET),
    PORTUGUESE(LATIN, POR_ALPHABET),
    CZECH(LATIN, CZE_ALPHABET),
    POLISH(LATIN, POL_ALPHABET),
    ;

    private final Type type;
    private final String letters;

    Alphabet(Type type, String letters) {
        this.type = type;
        this.letters = letters;
    }

    public Type getType() {
        return type;
    }

    public String getLetters() {
        return letters;
    }

    public enum Type {

        CYRILLIC(RUS_LETTERS),
        LATIN(ENG_LETTERS),
        ;

        private Set<Character> baseLetters;

        Type(Set<Character> baseLetters) {
            this.baseLetters = baseLetters;
        }

        public Set<Character> getBaseLetters() {
            return baseLetters;
        }
    }
}
