package ru.yandex.direct.redislock;

import java.util.concurrent.locks.Lock;

/**
 * {@link Lock}-like distributed structure. Note: it may fail to lock due unknown reasons (e. g. network failure).
 */
public interface DistributedLock {
    /**
     * @return {@code true} if the lock was acquired and
     * {@code false} otherwise
     * @throws DistributedLockException
     * @see Lock#lock()
     */
    boolean lock() throws DistributedLockException, InterruptedException;

    /**
     * @return {@code true} if the lock was acquired and
     * {@code false} otherwise
     * @throws DistributedLockException
     * @see Lock#tryLock()
     */
    boolean tryLock() throws DistributedLockException;

    /**
     * @return {@code true} if the lock was released and
     * {@code false} otherwise
     * @throws DistributedLockException
     * @see Lock#unlock()
     */
    boolean unlock() throws DistributedLockException;

    /**
     * unlocks semaphore's(!) permits
     *
     * @throws DistributedLockException
     */
    void unlockByEntry() throws DistributedLockException;

    boolean isLocked();
}
