package ru.yandex.direct.redislock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ResourceLoader {
    private ResourceLoader() {
    }

    /**
     * reads resource into String
     *
     * @param name resource path
     * @return resourse as String
     * @throws IOException
     */
    public static String readResource(String name) throws IOException {
        //Can be simplified with {@link org.apache.commons.io.IOUtils#toString(InputStream, Charset)}
        try (BufferedReader rdr = new BufferedReader(
                new InputStreamReader(ResourceLoader.class.getResourceAsStream(name), StandardCharsets.UTF_8))) {
            String line = rdr.readLine();
            StringBuilder bldr = new StringBuilder();
            if (line != null) {
                bldr.append(line);
                while ((line = rdr.readLine()) != null) {
                    bldr.append('\n').append(line);
                }
            }
            return bldr.toString();
        }
    }

    /**
     * reads resource into List of String
     *
     * @param name resource path
     * @return resourse as List of String
     * @throws IOException
     */
    public static List<String> readResourceAsLines(String name) throws IOException {
        //can be simplified with {@link org.apache.commons.io.IOUtils#readLines(InputStream, Charset)}
        try (BufferedReader rdr = new BufferedReader(
                new InputStreamReader(ResourceLoader.class.getResourceAsStream(name), StandardCharsets.UTF_8))) {
            String line;
            List<String> lines = new ArrayList<>();
            while ((line = rdr.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
    }
}
