package ru.yandex.direct.redislock.clock;

/**
 * Interface for increase testability of methods, that do time/sleep specific things
 */
public interface LockClock {
    /**
     * Instance of default clock implementation (using System time)
     */
    LockClock SYSTEM = new SystemClock();

    /**
     * Analogue of System.nanoTime()
     *
     * @return - the current value of the running JVM time source, in nanoseconds
     */
    long nanoTime();

    /**
     * Pause execution of thread for specified time
     *
     * @param millis - time interval in milliseconds to sleep
     * @throws InterruptedException
     */
    void sleep(long millis) throws InterruptedException;
}
