package ru.yandex.direct.redislock.clock;

import java.util.concurrent.TimeUnit;

/**
 * Implementation of LockClock, that useful for unit-testing,
 * time is fixed and changes only manual (through sleep)
 */
public class ManualClock implements LockClock {
    private long currentNanoTime = 1;

    /**
     * {@inheritDoc}
     *
     * @return
     */
    @Override
    public long nanoTime() {
        return currentNanoTime;
    }

    /**
     * {@inheritDoc}
     *
     * @return
     */
    @Override
    public void sleep(long millis) {
        currentNanoTime += TimeUnit.MILLISECONDS.toNanos(millis);
    }
}
