package ru.yandex.direct.redislock.clock;

/**
 * Default implementation of {@see LockClock}, that uses System and Thread classes
 */
public class SystemClock implements LockClock {
    /**
     * {@inheritDoc}
     *
     * @return
     */
    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    /**
     * {@inheritDoc}
     *
     * @return
     */
    @Override
    public void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }
}
