-- usage: evalsha sha1digest 1 keyPrefix candidateValue keyTTL maxLocksNum
--[[
 parameters description:
 keyPrefix.      Redis uses it to choose processing server. Script occupies 'keyprefix permitNo' (with no space) key if it is absent.
 Curly brackets are required to distribute keys properly (i.e. witin the same node)
 candidateValue. Script assigns reserved key to this value.
 keyTTL.         Lifetime of probed key
 maxLocksNum     limit of key probing attempts
 returns probed key or nil if script failed to probe any.
]]

-- keyPrefix      = KEYS[1] (string)
-- candidateValue = ARGV[1] (string)
-- keyTTL         = ARGV[2] (int, milliseconds)
-- maxLocksNum    = ARGV[3] (int)

-- e.g. evalsha sha1digest 1 'uid42' 'ts424242' 9000 10
-- 1

local candidateValue = ARGV[1];
local keyTTL = ARGV[2];
local maxLocksNum = ARGV[3];
local keyPrefix = KEYS[1];
for keySuffix = 1, maxLocksNum, 1 do
    local keyCandidate = keyPrefix .. keySuffix;
    if not redis.call('GET', keyCandidate) then
        redis.call('PSETEX', keyCandidate, keyTTL, candidateValue);
        return keyCandidate;
    end
end
return nil;
