package ru.yandex.direct.regions;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.collect.ImmutableList.toImmutableList;
import static com.google.common.collect.ImmutableSet.toImmutableSet;
import static ru.yandex.direct.regions.Region.REGION_TYPE_COUNTRY;

@ParametersAreNonnullByDefault
public class GeoTreeConstants {
    private final List<Long> globalRegionParts;
    private final Set<Long> countriesIds;

    public GeoTreeConstants(Collection<Region> regions) {
        this.globalRegionParts = regions.stream()
                .filter(region -> region.getParent().getId() == Region.GLOBAL_REGION_ID)
                .map(Region::getId)
                .filter(regionId -> !regionId.equals(Region.GLOBAL_REGION_ID))
                .collect(toImmutableList());
        this.countriesIds = regions.stream()
                .filter(r -> r.getType() == REGION_TYPE_COUNTRY)
                .map(Region::getId)
                .collect(toImmutableSet());
    }

    public List<Long> getGlobalRegionParts() {
        return globalRegionParts;
    }

    public Set<Long> getCountriesIds() {
        return countriesIds;
    }
}
