package ru.yandex.direct.regions;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RegionsWithCount {
    private List<Long> ids;
    private Long count;

    public RegionsWithCount(List<Long> ids, Long count) {
        this.ids = ids;
        this.count = count;
    }

    public List<Long> getIds() {
        return ids;
    }

    public Long getCount() {
        return count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegionsWithCount that = (RegionsWithCount) o;
        return ids.equals(that.ids) &&
                count.equals(that.count);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ids, count);
    }
}
