package ru.yandex.direct.regions;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.regions.Region.UKRAINE_REGION_ID;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@ParametersAreNonnullByDefault
public class SimpleGeoTreeFactory implements GeoTreeFactory {
    private final Map<GeoTreeType, GeoTree> treeMap;

    public SimpleGeoTreeFactory(Map<GeoTreeType, GeoTree> treeMap) {
        this.treeMap = treeMap;
    }

    public SimpleGeoTreeFactory(List<GeoTree> geoTrees) {
        this.treeMap = listToMap(geoTrees, GeoTree::getGeoTreeType);
    }

    @Override
    public GeoTree getApiGeoTree() {
        return treeMap.get(GeoTreeType.API);
    }

    @Override
    public GeoTree getRussianGeoTree() {
        return treeMap.get(GeoTreeType.RUSSIAN);
    }

    @Override
    public GeoTree getGlobalGeoTree() {
        return treeMap.get(GeoTreeType.GLOBAL);
    }

    @Override
    public GeoTree getTranslocalGeoTree(long clientCountryId) {
        if (clientCountryId == UKRAINE_REGION_ID) {
            return getGlobalGeoTree();
        }

        return getRussianGeoTree();
    }
}
