package ru.yandex.direct.result;

import ru.yandex.direct.utils.converter.Converter;

public class ResultConverters {
    private ResultConverters() {
    }

    @SuppressWarnings("WeakerAccess")
    public static <T1, T2> Converter<Result<T1>, Result<T2>> resultValueConverter(Converter<T1, T2> valueConverter) {
        return source -> new Result<>(
                valueConverter.convert(source.getResult()), source.getValidationResult(), source.getState());

    }

    @SuppressWarnings("WeakerAccess")
    public static <T1, T2> Converter<MassResult<T1>, MassResult<T2>> massResultConverter(
            Converter<Result<T1>, Result<T2>> resultConverter) {
        return source -> new MassResult<>(
                resultConverter.convertList(source.getResult()),
                source.getValidationResult(),
                source.getState()
        );

    }

    public static <T1, T2> Converter<MassResult<T1>, MassResult<T2>> massResultValueConverter(
            Converter<T1, T2> valueConverter) {
        return massResultConverter(resultValueConverter(valueConverter));
    }
}
