package ru.yandex.direct.richcontent;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.richcontent.model.UrlInfo;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class RichContentClient {

    private final RichContentApi richContentApi;

    public RichContentClient(String baseUrl, ParallelFetcherFactory fetcherFactory) {
        richContentApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("rich_content_client")
                .withBaseUrl(baseUrl)
                .build()
                .create(RichContentApi.class);
    }

    public UrlInfo getUrlInfo(String url) {
        return getUrlInfo(url, true);
    }

    public UrlInfo getUrlInfo(String url, boolean crawl) {
        var call = richContentApi.getUrlInfo("direct", url, Boolean.toString(crawl));
        var serviceResponse = call.execute();
        checkResultForErrors(serviceResponse, RichContentClientException::new);
        return serviceResponse.getSuccess();
    }
}
