package ru.yandex.direct.rotor.client.model;

import java.lang.reflect.Type;

import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.http.smart.converter.ResponseConverter;

public class RotorImageResponseConverter implements ResponseConverter<RotorImageResponse> {
    private static final Logger logger = LoggerFactory.getLogger(RotorImageResponseConverter.class);

    @Override
    public RotorImageResponse convert(Response response, Type responseType) {
        if ("200".equals(response.getHeader("X-Rotor-HttpCode")) &&
                "TExecuteResponse_EStatus_OK".equals(response.getHeader("X-Rotor-Status"))) {
            RotorImageResponse image = new RotorImageResponse();
            image.setImage(response.getResponseBodyAsBytes());
            return image;
        }
        logger.warn("Got bad response from Rotor: status_code={}, headers={}", response.getStatusCode(),
                response.getHeaders());
        return null;
    }
}
