package ru.yandex.direct.rotor.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RotorPayload {
    @JsonProperty("TvmServiceTicket")
    private String tvmServiceTicket;

    @JsonProperty("Url")
    private String url;

    @JsonProperty("Source")
    private String source;

    @JsonProperty("Options")
    private Options options = new Options();

    @JsonProperty("HttpResponse")
    private String httpResponse;

    public String getTvmServiceTicket() {
        return tvmServiceTicket;
    }

    public void setTvmServiceTicket(String tvmServiceTicket) {
        this.tvmServiceTicket = tvmServiceTicket;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Options getOptions() {
        return options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public String getHttpResponse() {
        return httpResponse;
    }

    public void setHttpResponse(String httpResponse) {
        this.httpResponse = httpResponse;
    }

    //список параметров https://a.yandex-team.ru/arc/trunk/arcadia/yweb/robot/js/rotor/proto/execute.proto
    public static class Options {
        @JsonProperty("ScreenshotMode")
        private byte screenshotMode = 0;

        @JsonProperty("OutputFormat")
        private OutputFormat outputFormat = new OutputFormat();

        @JsonProperty("ViewPortSize")
        private ViewPortSize viewPortSize = new ViewPortSize();

        @JsonProperty("Plugins")
        private Plugins plugins = new Plugins();

        @JsonProperty("EnableImages")
        private Boolean enableImages = true;

        @JsonProperty("EnableAdblock")
        private Boolean enableAdblock = false;

        @JsonProperty("Trace")
        private Boolean trace = false;

        public byte getScreenshotMode() {
            return screenshotMode;
        }

        public void setScreenshotMode(byte screenshotMode) {
            this.screenshotMode = screenshotMode;
        }

        public OutputFormat getOutputFormat() {
            return outputFormat;
        }

        public void setOutputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
        }

        public ViewPortSize getViewPortSize() {
            return viewPortSize;
        }

        public void setViewPortSize(ViewPortSize viewPortSize) {
            this.viewPortSize = viewPortSize;
        }

        public Plugins getPlugins() {
            return plugins;
        }

        public void setPlugins(Plugins plugins) {
            this.plugins = plugins;
        }

        public Boolean getEnableImages() {
            return enableImages;
        }

        public void setEnableImages(Boolean enableImages) {
            this.enableImages = enableImages;
        }

        public Boolean getEnableAdblock() {
            return enableAdblock;
        }

        public void setEnableAdblock(Boolean enableAdblock) {
            this.enableAdblock = enableAdblock;
        }

        public Boolean getTrace() {
            return trace;
        }

        public void setTrace(Boolean trace) {
            this.trace = trace;
        }
    }

    public static class OutputFormat {
        @JsonProperty("Html")
        private Boolean html = false;

        @JsonProperty("Png")
        private Boolean png = true;

        public Boolean getHtml() {
            return html;
        }

        public void setHtml(Boolean html) {
            this.html = html;
        }

        public Boolean getPng() {
            return png;
        }

        public void setPng(Boolean png) {
            this.png = png;
        }
    }


    public static class ViewPortSize {
        @JsonProperty("Width")
        private long width;

        @JsonProperty("Height")
        private long height;

        public long getWidth() {
            return width;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public long getHeight() {
            return height;
        }

        public void setHeight(long height) {
            this.height = height;
        }
    }


    public static class Plugins {
        @JsonProperty("Flash")
        private Boolean flash = false;

        public Boolean getFlash() {
            return flash;
        }

        public void setFlash(Boolean png) {
            this.flash = png;
        }
    }
}
