package ru.yandex.direct.rotor.client.model;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RotorResponse {
    @JsonProperty("Url")
    String url;

    @JsonProperty("ResultUrl")
    String resultUrl;

    @JsonProperty("UrlTrace")
    List<String> urlTrace;

    @JsonProperty("Trace")
    RotorTraceResponse trace;

    public String getUrl() {
        return url;
    }

    public String getResultUrl() {
        return resultUrl;
    }

    public List<String> getUrlTrace() {
        return urlTrace;
    }

    @Nullable
    public RotorTraceResponse getTrace() {
        return trace;
    }
}
