package ru.yandex.direct.scheduler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.utils.Condition;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

/**
 * @deprecated Use {@link Hourglass} + {@link HourglassDaemon} instead.
 *
 * Аннотация для джоба-демона в шедулере (сам демон бежит постоянно, регулярно запускает внутренний джоб,
 * шедулер регулярно проверяет, что демон не умер, и в случае чего перезапускает его)
 */
@Deprecated
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Component
@Inherited
@Scope(SCOPE_PROTOTYPE)
public @interface Daemon {
    /**
     * Раз в сколько секунд запускается внутренний джоб, который делает полезную работу
     *
     * @return Промежуток времени в секундах
     */
    int runPeriod() default 30;

    /**
     * Раз в сколько секунд шедулер будет проверять, что демон жив
     *
     * @return Промежуток времени в секундах
     */
    int checkPeriod() default 60;

    /**
     * Класс (реализующий {@link Condition}), содержащий логику "нужно ли использовать это расписание".
     * Должен быть помечен аннотацией {@link Component}, чтобы быть доступным в виде бина в текущем контексте.
     * <p>
     * Шедулер запланирует (использует) данное расписание только при истинном значении {@link Condition#evaluate()}}.
     *
     * @return класс с логикой если был задан, или {@link AlwaysTrue}
     */
    Class<? extends Condition> needSchedule() default AlwaysTrue.class;
}
