package ru.yandex.direct.scheduler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для джоба-демона в шедулере (сам демон бежит постоянно, регулярно запускает внутренний джоб,
 * шедулер регулярно проверяет, что демон не умер, и в случае чего перезапускает его)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface HourglassDaemon {

    /**
     * Максимальное количество запусков демона в цикле. Нужно для того, чтобы демоны время от времени переезжали с
     * одной машинки на другую
     */
    int maxExecuteIterations() default 1000;

    /**
     * Раз в сколько секунд запускается внутренний джоб, который делает полезную работу
     *
     * @return Промежуток времени в секундах
     */
    int runPeriod() default 30;
}
