package ru.yandex.direct.scheduler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited

/**
 *
 * Указывает период, в секундах, для растягивания времени старта. По умолчанию для периодических задач этот период равен периоду
 * запуска, а для крона равен 0 (растягивания нет)
 *
 * Растягивание - сдвигает время старта относительно вычисленного на некоторую случаную величину. Нужно чтобы избежать одноврменного запуска задач,
 * и пиков нагрузки на БД.
 *
 */

public @interface HourglassStretchPeriod {
    int value() default 3600;
}
