package ru.yandex.direct.scheduler;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.direct.scheduler.support.WrappedJob;

/**
 * Интерсептор для задач.
 */
@FunctionalInterface
@ParametersAreNonnullByDefault
public interface JobInterceptor {
    /**
     * Обернуть задачу в какой-нибудь свой код
     *
     * @param code        Вызов этого Job нужно обернуть
     * @param originalJob Объект изначального Job (может быть полезен для получения аннотаций)
     * @return Обёрнутый Job (или {@code originalJob}, если ничего делать не надо)
     */
    @Nonnull
    WrappedJob wrap(WrappedJob code, BaseDirectJob originalJob);
}
