package ru.yandex.direct.scheduler;

import java.util.List;

import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.direct.scheduler.support.WrappedJob;

import static java.util.Arrays.asList;

/**
 * Список JobInterceptor-ов, нужен для явного указания порядка
 */
public class JobInterceptorsList {
    private final List<JobInterceptor> interceptors;

    public JobInterceptorsList(JobInterceptor... interceptors) {
        this.interceptors = asList(interceptors);
    }

    /**
     * Обернуть job во все интерсепторы по-порядку
     */
    public WrappedJob wrap(BaseDirectJob job) {
        WrappedJob wrappedJob = job;
        for (JobInterceptor interceptor : interceptors) {
            wrappedJob = interceptor.wrap(wrappedJob, job);
        }
        return wrappedJob;
    }
}
