package ru.yandex.direct.scheduler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

/**
 * Прерывает исполнение Standalone Spring приложения. Нужен только для того чтобы явно показать,
 * что сначала закроется контекст, после чего отработает System.exit. В случае регистрации shutdownHook и простого вызова
 * System.exit() закрытие контекста может быть неочевидным.
 */
@Component
public class SpringAppTerminator {
    private final ConfigurableApplicationContext applicationContext;

    @Autowired
    public SpringAppTerminator(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void terminate(int status) {
        applicationContext.close();
        System.exit(status);
    }
}
