package ru.yandex.direct.scheduler.hourglass;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.scheduler.hourglass.implementations.TaskParametersMapImpl;

public interface TaskParametersMap {
    int size();

    boolean isEmpty();

    boolean containsKey(String key);

    String get(String key);

    Set<String> keySet();

    Collection<String> values();

    Set<Map.Entry<String, String>> entrySet();

    String getAsString();

    static TaskParametersMap of() {
        return new TaskParametersMapImpl();
    }

    static TaskParametersMap of(String k1, String v1) {
        return new TaskParametersMapImpl(Map.of(k1, v1));
    }

    static TaskParametersMap of(String k1, String v1, String k2, String v2) {
        return new TaskParametersMapImpl(Map.of(k1, v1, k2, v2));
    }

    static TaskParametersMap of(String k1, String v1, String k2, String v2, String k3, String v3) {
        return new TaskParametersMapImpl(
                Map.of(k1, v1, k1, v2, k3, v3));
    }

    static TaskParametersMap of(String k1, String v1, String k2, String v2, String k3, String v3, String k4,
                                String v4) {
        return new TaskParametersMapImpl(
                Map.of(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    static TaskParametersMap of(String k1, String v1, String k2, String v2, String k3, String v3, String k4,
                                String v4, String k5, String v5) {
        return new TaskParametersMapImpl(
                Map.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    static TaskParametersMap of(Map<String, String> paramsMap) {
        return new TaskParametersMapImpl(Map.copyOf(paramsMap));
    }
}
