package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.List;

import org.springframework.context.ApplicationContext;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.Hourglasses;
import ru.yandex.direct.scheduler.hourglass.HourglassJob;

public class FilteredTaskListProvider extends TaskListProviderImpl {
    private final String jobClass;
    private final ApplicationContext context;

    public FilteredTaskListProvider(ApplicationContext context,
                                    String clazz
    ) {
        super(context);
        this.jobClass = clazz;
        this.context = context;
    }

    @Override
    protected List<HourglassJob> listJobs() {
        Class<?> clazz;
        try {
            clazz = Class.forName(jobClass);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }

        HourglassJob job = (HourglassJob) context.getBean(clazz);

        if (job.getClass().isAnnotationPresent(Hourglass.class) || job.getClass()
                .isAnnotationPresent(Hourglasses.class)) {
            return List.of(job);
        }

        return List.of();
    }
}
