package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.List;

import org.springframework.beans.factory.DisposableBean;

import ru.yandex.direct.hourglass.SchedulerService;
import ru.yandex.direct.hourglass.implementations.updateschedule.ScheduleRecord;
import ru.yandex.direct.hourglass.updateschedule.ScheduleUpdateService;
import ru.yandex.direct.scheduler.hourglass.ScheduleRecordListProvider;
import ru.yandex.direct.scheduler.hourglass.TaskFactory;

public class HourglassScheduler implements DisposableBean {

    private final ScheduleRecordListProvider scheduleRecordListProvider;
    private final SchedulerService schedulerService;
    private final ScheduleUpdateService scheduleUpdateService;

    public HourglassScheduler(ScheduleRecordListProvider scheduleRecordListProvider,
                              TaskFactory taskFactory,
                              SchedulerService schedulerService,
                              ScheduleUpdateService scheduleUpdateService) {
        this.scheduleRecordListProvider = scheduleRecordListProvider;
        this.schedulerService = schedulerService;
        this.scheduleUpdateService = scheduleUpdateService;
        schedulerService.setJobFactory(taskFactory::startJob);
    }

    public void saveSchedule() {
        List<ScheduleRecord> records = scheduleRecordListProvider.getRecords();
        scheduleUpdateService.init(records);
    }

    public void start() {
        schedulerService.start();
    }

    public void stop() {
        schedulerService.stop();
    }

    @Override
    public void destroy() {
        stop();
    }
}
