package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.Objects;

import ru.yandex.direct.scheduler.hourglass.ParamDescription;
import ru.yandex.direct.scheduler.hourglass.TaskParametersMap;

public class ParamDescriptionImpl implements ParamDescription {
    private final int paramNumber;
    private final int paramsGroupSize;
    private final TaskParametersMap taskParametersMap;

    public ParamDescriptionImpl(int paramNumber, int paramsGroupSize, TaskParametersMap taskParametersMap) {
        this.paramNumber = paramNumber;
        this.paramsGroupSize = paramsGroupSize;
        this.taskParametersMap = taskParametersMap;
    }

    public ParamDescriptionImpl(TaskParametersMap taskParametersMap) {
        this(0, 0, taskParametersMap);
    }

    @Override
    public int paramNumber() {
        return paramNumber;
    }

    @Override
    public int paramGroupSize() {
        return paramsGroupSize;
    }

    @Override
    public TaskParametersMap paramMap() {
        return taskParametersMap;
    }

    public static ParamDescriptionImpl empty() {
        return new ParamDescriptionImpl(0, 0, TaskParametersMap.of());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ParamDescriptionImpl that = (ParamDescriptionImpl) o;
        return paramNumber == that.paramNumber &&
                paramsGroupSize == that.paramsGroupSize &&
                Objects.equals(taskParametersMap, that.taskParametersMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paramNumber, paramsGroupSize, taskParametersMap);
    }

    @Override
    public String toString() {
        return "ParamDescriptionImpl{" +
                "paramNumber=" + paramNumber +
                ", paramsGroupSize=" + paramsGroupSize +
                ", taskParametersMap=" + taskParametersMap +
                '}';
    }
}
