package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;

import ru.yandex.direct.hourglass.implementations.updateschedule.ScheduleRecord;
import ru.yandex.direct.scheduler.hourglass.ScheduleRecordListProvider;
import ru.yandex.direct.scheduler.hourglass.TaskListProvider;
import ru.yandex.direct.scheduler.hourglass.schedule.ScheduleInfoConverter;

public class ScheduleRecordListProviderImpl implements ScheduleRecordListProvider {
    private final TaskListProvider taskListProvider;
    private final ScheduleInfoConverter scheduleInfoConverter;
    private final TaskParameterizer taskParameterizer;
    private final JobScheduleInfoFactory jobScheduleInfoFactory;

    private List<ScheduleRecord> records;

    public ScheduleRecordListProviderImpl(TaskListProvider taskListProvider,
                                          ScheduleInfoConverter scheduleInfoConverter,
                                          TaskParameterizer taskParameterizer,
                                          JobScheduleInfoFactory jobScheduleInfoFactory) {
        this.taskListProvider = taskListProvider;
        this.scheduleInfoConverter = scheduleInfoConverter;
        this.taskParameterizer = taskParameterizer;
        this.jobScheduleInfoFactory = jobScheduleInfoFactory;
    }

    @Override
    public List<ScheduleRecord> getRecords() {
        return records;
    }

    @PostConstruct
    public void init() {
        var taskList = taskListProvider.getTasks();
        List<ScheduleRecord> recordsLocal = new ArrayList<>();

        for (var task : taskList) {
            var paramsDescriptions = taskParameterizer.getAllParameters(task.getTaskClass());
            if (paramsDescriptions.isEmpty()) {
                paramsDescriptions = List.of(ParamDescriptionImpl.empty());
            }

            for (var param : paramsDescriptions) {
                var scheduleInfo =
                        jobScheduleInfoFactory.getScheduleInfo(task, param);
                var record = new ScheduleRecord()
                        .setName(task.getName())
                        .setParam(param.paramMap().getAsString())
                        .setScheduleHashSum(scheduleInfoConverter.serializeAndEncodeSchedule(scheduleInfo));

                record.setMeta(scheduleInfoConverter.serializeSchedule(scheduleInfo));
                recordsLocal.add(record);

            }
        }
        this.records = recordsLocal;
    }
}
