package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import ru.yandex.direct.hourglass.HourglassProperties;
import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.MonitoringWriter;
import ru.yandex.direct.hourglass.RandomChooser;
import ru.yandex.direct.hourglass.SchedulerInstancePinger;
import ru.yandex.direct.hourglass.TaskThreadPool;
import ru.yandex.direct.hourglass.implementations.SchedulerServiceImpl;
import ru.yandex.direct.hourglass.implementations.ThreadsHierarchy;
import ru.yandex.direct.hourglass.implementations.internal.SystemThread;
import ru.yandex.direct.hourglass.storage.PrimaryId;
import ru.yandex.direct.hourglass.storage.Storage;
import ru.yandex.direct.tracing.TraceGuard;
import ru.yandex.direct.tracing.TraceHelper;

public class SchedulerTracingWrapper extends SchedulerServiceImpl {
    private final TraceHelper traceHelper;

    public SchedulerTracingWrapper(Storage storage,
            ThreadsHierarchy threadsHierarchy,
            TaskThreadPool taskThreadPool,
            InstanceId schedulerId,
            RandomChooser<PrimaryId> randomChooser,
            HourglassProperties hourglassProperties,
            MonitoringWriter monitoringWriter,
            SchedulerInstancePinger schedulerInstancePinger,
            TraceHelper traceHelper)
    {
        super(storage, threadsHierarchy, taskThreadPool, schedulerId, randomChooser,
                hourglassProperties, schedulerInstancePinger, monitoringWriter);

        this.traceHelper = traceHelper;
    }

    @Override
    protected SystemThread scheduleSystemJob(Runnable command, ThreadFactory threadFactory, String name, long period,
            TimeUnit unit)
    {

        Runnable tracerableRunnable = () -> {
            try (TraceGuard guard = traceHelper.guard(name)) {
                command.run();
            }
        };

        return super.scheduleSystemJob(tracerableRunnable, threadFactory, name, period, unit);
    }

}
