package ru.yandex.direct.scheduler.hourglass.implementations;

import java.time.Instant;
import java.util.Objects;
import java.util.function.BinaryOperator;

import javax.annotation.Nonnull;

import ru.yandex.direct.scheduler.hourglass.HourglassJob;
import ru.yandex.direct.scheduler.hourglass.TaskDescription;

public class TaskDescriptionImpl implements TaskDescription {
    private final Class<? extends HourglassJob> taskClass;
    private final String name;
    private final BinaryOperator<Instant> scheduleReducer;

    private TaskDescriptionImpl(Class<? extends HourglassJob> taskClass, String name,
                                BinaryOperator<Instant> scheduleReducer) {
        this.taskClass = taskClass;
        this.name = name;
        this.scheduleReducer = scheduleReducer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private Builder() {
        }

        private Class<? extends HourglassJob> taskClass;
        private String name;
        private BinaryOperator<Instant> scheduleReducer = (a, b) -> (a.compareTo(b) < 0 ? a : b);

        public Builder setTaskClass(Class<? extends HourglassJob> taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setScheduleReducer(BinaryOperator<Instant> scheduleReducer) {
            this.scheduleReducer = scheduleReducer;
            return this;
        }

        public TaskDescriptionImpl build() {
            return new TaskDescriptionImpl(taskClass, name, scheduleReducer);
        }
    }


    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Class<? extends HourglassJob> getTaskClass() {
        return taskClass;
    }

    @Override
    public String getName() {
        return name;
    }

    @Nonnull
    @Override
    public BinaryOperator<Instant> getScheduleReducer() {
        return scheduleReducer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskDescriptionImpl that = (TaskDescriptionImpl) o;
        return Objects.equals(taskClass, that.taskClass) &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taskClass, name);
    }

    @Override
    public String toString() {
        return "TaskDescriptionImpl{" +
                "taskClass=" + taskClass +
                ", name='" + name + '\'' +
                '}';
    }
}
