package ru.yandex.direct.scheduler.hourglass.implementations;

import java.time.Instant;

import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.hourglass.TaskHooks;
import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.scheduler.hourglass.HourglassInterruptibleJob;
import ru.yandex.direct.scheduler.hourglass.HourglassJob;
import ru.yandex.direct.scheduler.hourglass.TaskParametersMap;
import ru.yandex.direct.scheduler.hourglass.schedule.NextRunCalculator;
import ru.yandex.direct.scheduler.support.JobExecutingMonitor;

public class TaskHooksImpl implements TaskHooks {
    private static final Logger logger = LoggerFactory.getLogger(TaskHooksImpl.class);

    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final HourglassJob job;
    private final JobExecutingMonitor jobExecutingMonitor;
    private final NextRunCalculator nextRunCalculator;
    private final TaskParametersMap taskParametersMap;

    public TaskHooksImpl(HourglassJob job,
                         JobExecutingMonitor jobExecutingMonitor,
                         NextRunCalculator nextRunCalculator,
                         TaskParametersMap taskParametersMap) {
        this.job = job;
        this.jobExecutingMonitor = jobExecutingMonitor;
        this.nextRunCalculator = nextRunCalculator;
        this.taskParametersMap = taskParametersMap;
    }

    @Override
    public void onStart() {
        stopwatch.start();
    }

    @Override
    public void onFinish() {
        stopwatch.stop();
        jobExecutingMonitor.jobWasExecuted();
    }

    @Override
    public void run() {
        job.execute(taskParametersMap);
    }

    @Override
    public Instant calculateNextRun(TaskProcessingResult taskProcessingResult) {
        return nextRunCalculator.calculateNextRun(taskProcessingResult);
    }

    @Override
    public boolean interrupt() {
        if (job instanceof HourglassInterruptibleJob) {
            try {
                ((HourglassInterruptibleJob) job).interrupt();
                return true;
            } catch (Throwable e) {
                logger.warn("Some exception occured", e);
            }
        }

        return false;
    }

    @Override
    public void onShutdown() {
        job.onShutdown();
    }
}
