package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.PostConstruct;

import org.springframework.context.ApplicationContext;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.Hourglasses;
import ru.yandex.direct.scheduler.hourglass.HourglassJob;
import ru.yandex.direct.scheduler.hourglass.TaskDescription;
import ru.yandex.direct.scheduler.hourglass.TaskListProvider;

public class TaskListProviderImpl implements TaskListProvider {
    private final ApplicationContext context;
    private List<TaskDescription> taskDescriptions;

    public TaskListProviderImpl(ApplicationContext context) {
        this.context = context;
    }

    protected List<HourglassJob> listJobs() {
        return Stream.of(HourglassJob.class)
                .map(context::getBeansOfType)
                .map(Map::values)
                .flatMap(Collection::stream)
                .filter(task ->
                        task.getClass().isAnnotationPresent(Hourglass.class) || task.getClass()
                                .isAnnotationPresent(Hourglasses.class))
                .collect(Collectors.toList());
    }

    private void readJobList() {
        List<HourglassJob> jobs = listJobs();
        taskDescriptions = new ArrayList<>();
        for (HourglassJob job : jobs) {
            taskDescriptions.add(TaskDescriptionImpl.builder()
                    .setTaskClass(job.getClass())
                    .setName(job.getClass().getCanonicalName())
                    .build());
        }
    }

    @PostConstruct
    public void init() {
        readJobList();
    }

    @Override
    public Collection<TaskDescription> getTasks() {
        return taskDescriptions;
    }
}
