package ru.yandex.direct.scheduler.hourglass.implementations;

import java.util.Objects;

import ru.yandex.direct.scheduler.hourglass.TasksGroup;

public class TasksGroupImpl implements TasksGroup {
    private final String groupName;
    private final int groupSize;

    public TasksGroupImpl(String groupName, int groupSize) {
        this.groupName = groupName;
        this.groupSize = groupSize;
    }

    @Override
    public String groupName() {
        return groupName;
    }

    @Override
    public int groupSize() {
        return groupSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TasksGroupImpl that = (TasksGroupImpl) o;
        return groupSize == that.groupSize &&
                Objects.equals(groupName, that.groupName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupName, groupSize);
    }

    @Override
    public String toString() {
        return "TasksGroupImpl{" +
                "groupName='" + groupName + '\'' +
                ", groupSize=" + groupSize +
                '}';
    }
}
