package ru.yandex.direct.scheduler.hourglass.implementations.monitoring;

import ru.yandex.direct.hourglass.MonitoringWriter;
import ru.yandex.monlib.metrics.primitives.Counter;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

public class MonitoringWriterImpl implements MonitoringWriter {
    private final Counter expiredJobsCount;
    private final Counter lostTasksCount;
    private final Counter pingedTasksCount;
    private final Counter lockedTasksCount;
    private final Counter rescheduledTasksCount;
    private final Counter systemThreadErrors;
    private final Counter missedTasks;

    private final SchedulerPingMonitoring schedulerPingMonitoring;

    public MonitoringWriterImpl(MetricRegistry metricRegistry, SchedulerPingMonitoring schedulerPingMonitoring) {
        expiredJobsCount = metricRegistry.counter("expired_tasks_count");
        rescheduledTasksCount = metricRegistry.counter("rescheduled_tasks_count");
        lockedTasksCount = metricRegistry.counter("locked_tasks_count");
        pingedTasksCount = metricRegistry.counter("pinged_tasks_count");
        lostTasksCount = metricRegistry.counter("lost_tasks_count");
        systemThreadErrors = metricRegistry.counter("system_threads_errors");
        this.schedulerPingMonitoring = schedulerPingMonitoring;
        missedTasks = metricRegistry.counter("missed_tasks");
    }

    @Override
    public void expiredJobsFixed(int n) {
        expiredJobsCount.add(n);
    }

    @Override
    public void lostTaskDetected() {
        lostTasksCount.inc();
    }

    @Override
    public void tasksPinged(int n) {
        pingedTasksCount.add(n);
    }

    @Override
    public void tasksLocked(int n) {
        lockedTasksCount.add(n);
    }

    @Override
    public void tasksRescheduled(int n) {
        rescheduledTasksCount.add(n);
    }

    @Override
    public void missedTasks(int n) {
        missedTasks.add(n);
    }

    @Override
    public void systemThreadFailed() {
        systemThreadErrors.inc();
    }

    @Override
    public void schedulerPinged() {
        schedulerPingMonitoring.schedulerPinged();
    }
}
