package ru.yandex.direct.scheduler.hourglass.implementations.monitoring.juggler;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.InstanceMeta;
import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.scheduler.hourglass.implementations.monitoring.SchedulerPingListener;

import static ru.yandex.direct.scheduler.hourglass.implementations.monitoring.juggler.HourglassJugglerSender.getPrefixedService;

public class CheckInSchdedulerPingListener implements SchedulerPingListener {
    private final HourglassJugglerSender jugglerSender;
    private final InstanceId instanceId;
    private final InstanceMeta instanceMeta;

    public static final String CHECKIN_SERVICE = getPrefixedService("check-in");

    public CheckInSchdedulerPingListener(HourglassJugglerSender jugglerSender, InstanceId instanceId,
                                         InstanceMeta instanceMeta) {
        this.jugglerSender = jugglerSender;
        this.instanceId = instanceId;
        this.instanceMeta = instanceMeta;
    }

    @Override
    public void onPing() {
        sendCheckInEvent();
    }

    private void sendCheckInEvent() {
        String description = "Scheduler instance " + instanceId.toString() + ",  " + instanceMeta.getString() + " " +
                "successfully checked in";
        jugglerSender.sendEventSafely(new JugglerEvent(CHECKIN_SERVICE, JugglerStatus.OK, description));
    }
}
